<?php
/*-------------------------
Autor: Delmar Lopez
Web: www.softwys.com
Mail: softwysop@gmail.com
---------------------------*/
include 'is_logged.php'; // Archivo verifica que el usuario que intenta acceder a la URL está logueado
/* Connect To Database */
require_once "../db.php";
require_once "../php_conexion.php";
require_once "../funciones.php";

$action = (isset($_REQUEST['action']) && $_REQUEST['action'] != null) ? $_REQUEST['action'] : '';
if ($action == 'ajax') {
    // escaping, additionally removing everything that could be (html/javascript-) code
    $q = mysqli_real_escape_string($conexion, (strip_tags($_REQUEST['q'], ENT_QUOTES)));
    $aColumns = array('codigo_producto', 'nombre_producto'); // Columnas de búsqueda
    $sTable = "productos";
    $sWhere = "";
    if ($_GET['q'] != "") {
        $sWhere = "WHERE (";
        for ($i = 0; $i < count($aColumns); $i++) {
            $sWhere .= $aColumns[$i] . " LIKE '%" . $q . "%' OR ";
        }
        $sWhere = substr_replace($sWhere, "", -3);
        $sWhere .= ')';
    }
    include 'pagination.php'; // include pagination file
    // pagination variables
    $page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
    $per_page = 5; // how many records you want to show
    $adjacents = 4; // gap between pages after number of adjacents
    $offset = ($page - 1) * $per_page;
    // Count the total number of row in your table
    $count_query = mysqli_query($conexion, "SELECT count(*) AS numrows FROM $sTable  $sWhere");
    $row = mysqli_fetch_array($count_query);
    $numrows = $row['numrows'];
    $total_pages = ceil($numrows / $per_page);
    $reload = '../venta/prueba.php';
    // main query to fetch the data
    $sql = "SELECT * FROM  $sTable $sWhere LIMIT $offset,$per_page";
    $query = mysqli_query($conexion, $sql);
    // loop through fetched data
    if ($numrows > 0) {
?>

<div class="table-responsive">
    <table class="table table-bordered table-striped table-sm">
        <tr class="info">
            <th></th>
            <th>COD.</th>
            <th class='text-center'>PRODUCTOS</th>
            <th class='text-center'>STOCK</th>
            <th class='text-center'>CANT</th>
            <th class='text-center'>PRECIO</th>
            <th class='text-center' style="width: 36px;"></th>
        </tr>

        <?php
        while ($row = mysqli_fetch_array($query)) {
            $id_producto = $row['id_producto'];
            $codigo_producto = $row['codigo_producto'];
            $nombre_producto = $row['nombre_producto'];
            $stock_producto = $row['stock_producto'];
            $precio_venta = number_format($row["valor1_producto"], 2, '.', '');
            $image_path = $row['image_path'];
        ?>
        <tr>
            <td class='text-center'>
                <!--<img src="<?php echo $image_path; ?>" alt="Product Image" class='rounded-circle' width="60">-->
            </td>
            <td><?php echo $codigo_producto; ?></td>
            <td><?php echo $nombre_producto; ?></td>
            <td class="text-center"><?php echo stock($stock_producto); ?></td>
            <td class='col-xs-1' width="15%">
                <div class="pull-right">
                    <input type="text" class="form-control" style="text-align:center" id="cantidad_<?php echo $id_producto; ?>" value="1">
                </div>
            </td>
            <td class='col-xs-2' width="15%">
                <div class="pull-right">
                    <input type="text" class="form-control" style="text-align:right" id="precio_venta_<?php echo $id_producto; ?>" value="<?php echo $precio_venta; ?>" disabled>
                </div>
            </td>
            <td class='text-center'>
                <a class='btn btn-success' href="#" title="Agregar a Factura" onclick="agregar('<?php echo $id_producto ?>')">
                    <i class="fa fa-plus"></i>
                </a>
            </td>
        </tr>
        <?php } ?>

        <tr>
            <td colspan=6><span class="pull-right">
            <?php echo paginate($reload, $page, $total_pages, $adjacents); ?>
            </span></td>
        </tr>
    </table>
</div>

<!-- Modal para ingresar la clave -->
<div class="modal" id="authModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Autorización</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <p>Ingrese la clave para habilitar la modificación del precio:</p>
                <input type="password" id="authKey" class="form-control" placeholder="Clave de autorización">
                <button class="btn btn-primary mt-2" onclick="authorize()">Verificar</button>
                <small class="text-muted">Ejemplo de clave: xD</small>
            </div>
        </div>
    </div>
</div>

<script>
    // Clave autorizada (formato DDMMYYYY)
    const authKey = "13112024";

    // Función para verificar la clave
    function authorize() {
        const userKey = document.getElementById("authKey").value;
        if (userKey === authKey) {
            // Si la clave es correcta, habilita todos los campos de precio
            document.querySelectorAll("input[id^='precio_venta_']").forEach((input) => {
                input.disabled = false;
            });
            alert("Clave correcta. Puede modificar el precio.");
            $('#authModal').modal('hide');
        } else {
            alert("Clave incorrecta. Intente nuevamente.");
        }
    }
</script>

<button class="btn btn-info" onclick="$('#authModal').modal('show')">Ingresar Clave</button>

<?php
    }
    // Mensaje si no hay productos
    else {
?>
<div class="alert alert-warning alert-dismissible" role="alert" align="center">
    <strong>Aviso!</strong> No hay Registro de Producto
</div>
<?php
    }
}
?>
